(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3895,        159]*)
(*NotebookOutlinePosition[      4739,        186]*)
(*  CellTagsIndexPosition[      4695,        182]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ 
      Example\ 2.1  .4\ *) \)\(\[IndentingNewLine]\)\(k2[x_, s_] := \ 
      x\ s\  - \ x^2\ *s/2\  - \ s^3/3; 
    Integrate[\((\ x\ s\  - \ x^2\ *s/2\  - \ s^3/3)\)^2, \ {s, \ 0, \ 
        x}]\)\)\)], "Input"],

Cell[BoxData[
    \(x\^5\/3 - \(7\ x\^6\)\/15 + \(209\ x\^7\)\/1260\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a4 = 2*NIntegrate[%, \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(0.0192460317460317558`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(la1 = Sqrt[\((1/6)\)/%]\)], "Input"],

Cell[BoxData[
    \(2.94275276134998886`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Example\ 2.4  .2*) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(k2[x_, s_] := \ 
      0.25\ *Sqrt[x\ s]*\((\ \((x^2 + s^2)\)*\ Log[x] + 1 - x^2\ )\); 
    Integrate[k2[x, s]*k2[x, s], \ {s, \ 0, \ x}]\)], "Input"],

Cell[BoxData[
    \(0.03125`\ x\^3 - 0.0625`\ x\^5 + 0.03125`\ x\^7 + 
      0.09375`\ x\^5\ Log[x] - 0.09375`\ x\^7\ Log[x] + 
      0.0729166666666666518`\ x\^7\ Log[x]\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a4 = 2*NIntegrate[%, \ {x, \ 0, \ 1}]\)], "Input"],

Cell[BoxData[
    \(0.000895182291690203157`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(la1 = 1/\((%)\)^\((1/4)\)\)], "Input"],

Cell[BoxData[
    \(5.78125504912684107`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(B2 = 1/1024 - 11/12288\)], "Input"],

Cell[BoxData[
    \(1\/12288\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(la2 = Sqrt[2/%]/la1\)], "Input"],

Cell[BoxData[
    \(27.1164897943397908`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(eigenvalue1 = Sqrt[la1]\)], "Input"],

Cell[BoxData[
    \(2.40442405767511013`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(eigenvalue2 = Sqrt[la2]\)], "Input"],

Cell[BoxData[
    \(5.20734959401995478`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[11/12288]\)], "Input"],

Cell[BoxData[
    \(0.000895182291666666429`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{20, Automatic}, {Automatic, 28}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 242, 5, 59, "Input"],
Cell[1984, 58, 81, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2102, 64, 66, 1, 27, "Input"],
Cell[2171, 67, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2264, 73, 56, 1, 27, "Input"],
Cell[2323, 76, 54, 1, 26, "Output"]
}, Open  ]],
Cell[2392, 80, 57, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2474, 85, 170, 3, 59, "Input"],
Cell[2647, 90, 187, 3, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2871, 98, 70, 1, 27, "Input"],
Cell[2944, 101, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3039, 107, 58, 1, 27, "Input"],
Cell[3100, 110, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3191, 116, 55, 1, 27, "Input"],
Cell[3249, 119, 42, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3328, 125, 52, 1, 27, "Input"],
Cell[3383, 128, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3474, 134, 56, 1, 27, "Input"],
Cell[3533, 137, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3624, 143, 56, 1, 27, "Input"],
Cell[3683, 146, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3774, 152, 44, 1, 27, "Input"],
Cell[3821, 155, 58, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

